package gov.va.caret.view;

import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.ListTypeConstants;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.OrganizationConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BlsAe;
import gov.va.caret.model.BlsRe;
import gov.va.caret.model.Facil;
import gov.va.caret.model.ZipFy;
import gov.va.caret.model.impl.BlsAeImpl;
import gov.va.caret.model.impl.BlsReImpl;
import gov.va.caret.model.impl.FacilImpl;
import gov.va.caret.model.impl.ZipFyImpl;
import gov.va.caret.service.BlsAeLocalServiceUtil;
import gov.va.caret.service.BlsReLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.FacilLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.ZipFyLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;

import javax.portlet.PortletContext;

import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class BootStrapUtil {  
	
	private static Log _log = LogFactoryUtil.getLog(BootStrapUtil.class);
	
	final static int DISTRICT = 1;
	final static int VISN = 2;
	final static int VAMC = 3;
//  OLD PROTO-TYPE DEMO METADATA METHODS...
//	public static List<Map<String,Object>> getCbopcWork(){
//		List<Map<String,Object>> cbopcWork = new ArrayList<Map<String,Object>> ();
//		cbopcWork.add( Toolbox.getMap( "1","00064","New Application(O)","03/30/2015","07:31","Open","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00065","New Application(O)","03/30/2015","08:31","Open","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00066","New Application(H)","03/30/2015","09:51","Waiting for VA Enrollment","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00068","New Application(H)","03/30/2015","10:22","Open","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00069","CBOPC Correction","03/30/2015","12:31","Open","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00070","New Application(O)","03/30/2015","12:09","Open","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00071","New Application(O)","03/30/2015","14:39","Open","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00072","New Application(L)","03/30/2015","14:41","Open","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00073","CBOPC Correction","03/30/2015","14:55","Open","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00074","New Application(O)","03/30/2015","15:21","Open","7" ) );
//		cbopcWork.add( Toolbox.getMap( "1","00076","New Application(L)","03/30/2015","16:32","Open","7" ) );
//		   
//		return cbopcWork;
//	}
//	
//	public static List<Map<String,Object>> getReferrals(){
//		List<Map<String,Object>> referral = new ArrayList<Map<String,Object>> ();
//		referral.add( Toolbox.getMap( "##-###-######", "CSL", "##/##/####", "John Smith Jr.", "###-##-2321", "##/##/####", "Jane Smith", "In-Process") );
//		referral.add( Toolbox.getMap( "##-###-######", "CSL", "##/##/####", "John Smith Jr.", "###-##-2321", "##/##/####", "Jane Smith", "Call Attempt #2") );
//		referral.add( Toolbox.getMap( "##-###-######", "HRC", "##/##/####", "John Smith Jr.", "###-##-2321", "##/##/####", "Jane Smith", "Open") );
//		referral.add( Toolbox.getMap( "##-###-######", "CSL", "##/##/####", "John Smith Jr.", "###-##-2321", "##/##/####", "Jane Smith", "Call Attempt #1") );
//		referral.add( Toolbox.getMap( "##-###-######", "HRC", "##/##/####", "John Smith Jr.", "###-##-2321", "##/##/####", "Jane Smith", "In-Process") );
//		referral.add( Toolbox.getMap( "##-###-######", "CSL", "##/##/####", "John Smith Jr.", "###-##-2321", "##/##/####", "Jane Smith", "Open") );
//		referral.add( Toolbox.getMap( "##-###-######", "CSL", "##/##/####", "John Smith Jr.", "###-##-2321", "##/##/####", "Jane Smith", "Open") );
//		referral.add( Toolbox.getMap( "##-###-######", "HEC", "##/##/####", "John Smith Jr.", "###-##-2321", "##/##/####", "Jane Smith", "Open") )
//		;return referral;
//	}
//
//	public static List<Map<String,Object>> getPersonSearchResult(){
//		List<Map<String,Object>> person = new ArrayList<Map<String,Object>> ();
//		person.add( Toolbox.getMap( "64", "999-99-9991", "WALKER, JOHN","M", "YES","695" ) );
//		person.add( Toolbox.getMap( "64", "999-99-9992", "WALKER, JOHNIE","M", "YES","695" ) );
//		person.add( Toolbox.getMap( "64", "999-99-9992", "WALKER, JOHNY","M", "YES","695" ) );
//		return person;
//	}
//	
//	public static List<Map<String,Object>> getCaregiverResult(){
//		List<Map<String,Object>> cgResult = new ArrayList<Map<String,Object>> ();
//		cgResult.add( Toolbox.getMap("SMITH, STEVE", "##/##/####", "##/##/####" ) );
//		cgResult.add( Toolbox.getMap("SMITH, STEVE", "##/##/####", "##/##/####" ) ); 
//		cgResult.add( Toolbox.getMap("WALKER, NANCY", "##/##/####", "##/##/####" ) );
//		cgResult.add( Toolbox.getMap("GOMEZ, EDUARDO", "##/##/####", "##/##/####" ) );
//		cgResult.add( Toolbox.getMap("BROOKS, PHILLIP", "##/##/####", "##/##/####" ) );
//		return cgResult;
//	}
//	
//	
//	public static List<Map<String,Object>> getApplicationList(){
//		List<Map<String,Object>> application = new ArrayList<Map<String,Object>> ();
//		application.add( Toolbox.getMap( "##-###-######", "WALKER, SILVIA", "WALKER, POLLY", "WALKER,TOM", "##/##/####", "##/##/####", "CG REVOKED", "Dallas (982)" ) );
//		application.add( Toolbox.getMap( "##-###-######", "WALKER, BRAD", "WALKER, POLLY", "WALKER,TOM", "##/##/####", "##/##/####", "CG REVOKED", "Waco (981)" ) );
//		application.add( Toolbox.getMap( "##-###-######", "WALKER, BRAD", "WALKER, POLLY", "WALKER,TOM", "##/##/####", "##/##/####", "CG REVOKED", "Jacksonville (345)") );
//		application.add( Toolbox.getMap( "##-###-######", "WALKER, BRAD", "WALKER, POLLY", "WALKER,TOM", "##/##/####", "##/##/####", "CG REVOKED", "Dallas (982)" ) );
//		application.add( Toolbox.getMap( "##-###-######", "WALKER, BRAD", "WALKER, POLLY", "WALKER,TOM", "##/##/####", "##/##/####", "CG REVOKED", "Dallas (982), Waco (981)" ));
//		application.add( Toolbox.getMap( "##-###-######", "WALKER, BRAD", "WALKER, POLLY", "WALKER,TOM", "##/##/####", "-", "CG APPROVED", "Jacksonville (345)" ) );
//		return application;
//	}
//	
	public static void bootstrapPersonTable () throws ApplicationWorkFlowException{
		
		try {
			for ( User user: UserLocalServiceUtil.getUsers(QueryUtil.ALL_POS, QueryUtil.ALL_POS ) ){
				PersnLocalServiceUtil.addPersn(user, false);
			}
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
		
	}
	
	public static void bootstrapFacZip( PortletContext portletContext, String[] realPath ) throws ApplicationWorkFlowException, SystemException   {
		
		
		final String path = portletContext.getRealPath(realPath[0] + "/vmacLocations_0328.csv");
		_log.info("1 File is=" + path);
		_log.info("Final File is=" + realPath[0] + "/vmacLocations_0328.csv");
		File csvFile = new File ( realPath[0] + "/vmacLocations_0328.csv" );
		boolean exists = FileUtil.exists(csvFile);
		_log.info("File exists=" + exists );
		
		BufferedReader br = null;
		String line = "";

		try {
			NumberFormat nf = NumberFormat.getInstance();
			br = new BufferedReader(new FileReader(csvFile));
			int added = 0;
			int unfoundzips = 0;
			while ((line = br.readLine()) != null) {
				String[] zipFac = line.split(";");
				String zip = zipFac[0];
				String[] facMiles = zipFac[1].split("!");
				for ( String facMile : facMiles ){
					String[] rec = facMile.split(":");
					if ( rec.length == 2 ){
						
						while (zip.length() < 5){
							zip = "0"+ zip;
						}
						_log.debug( "zip:" + zip + ", facilityNumber:" + rec[0] + ", Distance:" + nf.parse(rec[1]) );
						
						String v = rec[0].trim();
						StringBuilder sb = new StringBuilder();
						for ( int index = 0; index < v.length(); index++ ){
							if ( Character.isLetterOrDigit( v.charAt(index) ) ){
								sb.append( v.charAt(index) );
							}
						}
						
						Facil facil = CaretLocalServiceUtil.getFacilityByNumber( sb.toString() );
						if ( facil != null ){
							ZipFy facilityZip = new ZipFyImpl();
							facilityZip.setFacilZip( zip.trim() );
							facilityZip.setFacilId( facil.getFacilId() );
							facilityZip.setDistance( nf.parse(rec[1]).doubleValue() );
							ZipFyLocalServiceUtil.updateZipFy(facilityZip);
							added++;
						} else {
							unfoundzips++;
						}
					}
				}
			}
			_log.info("added " + added + " bls rates, total zips not found: " + unfoundzips);
		} catch (FileNotFoundException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (IOException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (ParseException e) {
			ApplicationWorkFlowException.handleException(e);
		} finally {
			if (br != null) {
				try {
					br.close();
				} catch (IOException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
		}
		
		
	}
	
	public static void loadBlsRate( PortletContext portletContext, String[] realPath ) throws ApplicationWorkFlowException, SystemException {
		final String path = portletContext.getRealPath(realPath[0] + "/BLS_table_with_zip_codes.xlsx");
				_log.info("loadBlsRe()");
				_log.info("2 File is=" + path);
				_log.info("Final File is=" + realPath[0] + "/BLS_table_with_zip_codes.xlsx");
				File file = new File ( realPath[0] + "/BLS_table_with_zip_codes.xlsx" );
				boolean exists = FileUtil.exists(file);
				_log.info("File is " + file.getName() + ", exists=" + exists );
				if ( exists ){
					
					for ( BlsRe blsRe:  BlsReLocalServiceUtil.getBlsRes(QueryUtil.ALL_POS, QueryUtil.ALL_POS ) ) {
						BlsReLocalServiceUtil.deleteBlsRe( blsRe );
					}
					for ( BlsAe blsAe : BlsAeLocalServiceUtil.getBlsAes(QueryUtil.ALL_POS, QueryUtil.ALL_POS ) ){
						BlsAeLocalServiceUtil.deleteBlsAe(blsAe);
					}
					
					
					try {
						Workbook workbook = WorkbookFactory.create(file);
						Sheet sheet = workbook.getSheetAt(0);
//						Row headerRow = sheet.getRow(0);
//						for ( Cell cell: headerRow ){
//							String cellValue = cell.getStringCellValue();
//							_log.info("cellValue=" + cellValue );
//						}
						int added = 0;
						for ( Row row: sheet ){
							BlsRe bls = new BlsReImpl();
							int i = 0;
							Cell cell = row.getCell(i++);
							cell.setCellType(Cell.CELL_TYPE_STRING);
							if ( "Zipcode".equals(cell.toString().trim()) ) continue;
							bls.setZip( cell.getStringCellValue() );
							
							cell = row.getCell(i++);
							cell.setCellType(Cell.CELL_TYPE_STRING);
							Integer areaNumber = Integer.valueOf( cell.getStringCellValue().trim() );
							BlsAe area = BlsAeLocalServiceUtil.findByAreaNumber( areaNumber );
							
							cell = row.getCell(i++);
							cell.setCellType(Cell.CELL_TYPE_STRING);
							String areaName = cell.getStringCellValue().trim();
							
							if ( area == null ){
								area = new BlsAeImpl();
								area.setAreaNumber( areaNumber );
								area.setAreaName( areaName );
								BlsAeLocalServiceUtil.updateBlsAe(area);
							}
							bls.setBlsAeId( area.getBlsAeId() );
							
							cell = row.getCell(i++);
							cell.setCellType(Cell.CELL_TYPE_STRING);
							bls.setState( cell.getStringCellValue().trim()  );
							
							cell = row.getCell(i++);
							cell.setCellType(Cell.CELL_TYPE_STRING);
							bls.setH75( Double.valueOf( cell.getStringCellValue().trim() ) );
							
							cell = row.getCell(i++);
							cell.setCellType(Cell.CELL_TYPE_STRING);
							String location = cell.getStringCellValue().trim();
							bls.setCity( location.substring( 0, location.lastIndexOf(StringPool.COMMA) ) );
							
							cell = row.getCell(i++);
							if ( cell != null ){
								cell.setCellType(Cell.CELL_TYPE_STRING);
								bls.setCounty( cell.getStringCellValue().trim() );
							}
							int year = 2016;
							try{
								year = Integer.valueOf( PortletProps.get("bls-spreadsheet-year").trim() );
							} catch (NumberFormatException nfe){}
							bls.setYear(year);
							BlsReLocalServiceUtil.addBlsRe(bls);
							added++;
						}
						_log.info("added " + added + " bls rates ");
					} catch (InvalidFormatException e) {
						ApplicationWorkFlowException.handleException(e);
					} catch (IOException e) {
						ApplicationWorkFlowException.handleException(e);
					}
				}
	}

	
	public static void bootstrapOrgs(PortletContext portletContext, String[] realPath) throws SystemException, PortalException {

		String name = PortletProps.get(CaretStrPool.HEAD_ORG_NAME);
		
		Company company = CompanyLocalServiceUtil.getCompany( PortalUtil.getDefaultCompanyId() );
		Organization org = null;
		long caretOrganizationId = 0;
		ServiceContext serviceContext = new ServiceContext();
		serviceContext.setAddGuestPermissions(false);
		long userId = company.getDefaultUser().getUserId();
		try {
			org = OrganizationLocalServiceUtil.getOrganization( company.getCompanyId(), name );
		} catch ( com.liferay.portal.NoSuchOrganizationException nsoe ){
			throw new SystemException ( "Could not acquire needed Org... " + name );
		}
		caretOrganizationId = org.getOrganizationId();
		
		int count = OrganizationLocalServiceUtil.getOrganizationsCount();
		if ( count > 20 ){
			_log.info("count is:" + count);
			return;
		}
		
		
		String path = portletContext.getRealPath( realPath[0] + "/facilities.xlsx");
		_log.info("3 File is=" + path);
		_log.info("Final File is=" + realPath[0] + "/facilities.xlsx");
		File file = new File ( realPath[0] + "/facilities.xlsx" );
		
		//File file = new File ( path );
		boolean exists = FileUtil.exists(file);
		_log.info("File is " + file.getName() + ", exists=" + exists );
		if ( exists ){
			try {
				long districtOrgId = 0;
				long visnOrgId = 0;
				int added = 0;
				int addedF = 0;

				Workbook workbook = WorkbookFactory.create(file);
				Sheet sheet = workbook.getSheetAt(0);
				for ( Row row: sheet ){
					
					name = null;
					int context = 0;
					int i = 0;
					
					Cell cell = row.getCell(i);
					String[] vals = new String[5];
					if ( cell != null ){
						cell.setCellType(Cell.CELL_TYPE_STRING);
						vals[0] = cell.getStringCellValue().trim();
						if ( vals[i] != null && !vals[i].isEmpty() ){
							context = DISTRICT;
						}
					}
					cell = row.getCell(++i);
					if ( cell != null ){
						cell.setCellType(Cell.CELL_TYPE_STRING);
						vals[i] = cell.getStringCellValue().trim();
					}
					if ( context != DISTRICT ){
						cell = row.getCell(++i);
						if ( cell != null ){
							cell.setCellType(Cell.CELL_TYPE_STRING);
							vals[i] = cell.getStringCellValue().trim();
						}
						cell = row.getCell(++i);
						if ( cell != null ){
							cell.setCellType(Cell.CELL_TYPE_STRING);
							vals[i] = cell.getStringCellValue().trim() ;
						}
						cell = row.getCell(++i);
						if ( cell != null ){
							cell.setCellType(Cell.CELL_TYPE_STRING);
							vals[i] = cell.getStringCellValue().trim() ;
							if ( "Location".equals( vals[i] ) ){
								context = VISN;
							} else if ( vals[i] != null && !vals[i].isEmpty() ){
								context = VAMC;
							}
						}
					}
//					_log.info("context:" + context + ", 0:" + vals[0]+ ",1:" + vals[1]+ ",2:" + vals[2]+ ",3:" + vals[3]+ ",4:" + vals[4]);
					
					switch(context){
						case DISTRICT:
							name = vals[0] + StringPool.SPACE + vals[1];
							org = OrganizationLocalServiceUtil.addOrganization(userId, caretOrganizationId, name, 
									OrganizationConstants.TYPE_REGULAR_ORGANIZATION, 0, 0, ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, vals[0], false, serviceContext);
							districtOrgId = org.getOrganizationId();
							added++;
							break;
						case VISN:
							name = vals[1];
							org = OrganizationLocalServiceUtil.addOrganization(userId, districtOrgId, name,
									OrganizationConstants.TYPE_REGULAR_ORGANIZATION, 0, 0, ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, vals[2], false, serviceContext);
							visnOrgId = org.getOrganizationId();
							added++;
							break;
						case VAMC:
							name = vals[2];
							org = OrganizationLocalServiceUtil.addOrganization( userId, visnOrgId, name,
									OrganizationConstants.TYPE_REGULAR_ORGANIZATION, 0, 0, ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, StringPool.BLANK, false, serviceContext);
							added++;
							Facil facility = new FacilImpl();
							String v = vals[3].trim();
							StringBuilder sb = new StringBuilder();
							for ( int index = 0; index < v.length(); index++ ){
								if ( Character.isLetterOrDigit( v.charAt(index) ) ){
									sb.append( v.charAt(index) );
								}
							}
							
							facility.setFacilityNumber(sb.toString());
							facility.setLocation(vals[4]);
							facility.setGroupId( org.getOrganizationId() );
							FacilLocalServiceUtil.addFacil(facility);
							addedF++;
					}
				}
				_log.info("added " + added + " orgs and " + addedF + " facilities...");
			} catch (InvalidFormatException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (IOException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
	}
}
